/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.Vector;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskClusterIntegrity;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ClusterComponent
extends Component {
    private String m_referenceNode;
    private String m_sourceNode;
    private String[] m_IPAddrList;
    private String[] m_interfaceList;
    private Argument m_netArg = null;
    private boolean m_isRefNodeOk = true;
    private ParamPreReq m_paramPreReq = null;
    private String m_release;
    private String m_osdba;
    private String m_oraInv;

    ClusterComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        if (this.m_verificationType == 7) {
            Trace.out((String)"==== Skipping nodelist initialization for cluster intg.");
            super.init(false);
        } else {
            super.init();
        }
        switch (this.m_verificationType) {
            case 7: {
                Argument nodelistArg = this.m_paramMgr.getArgument(Argument.ARG_NODELIST);
                if (nodelistArg == null) {
                    try {
                        this.m_nodeList = VerificationUtil.getStaticNodelist();
                        Trace.out((String)("==== Using default nodelist for cluster integrity: " + VerificationUtil.strArr2List(this.m_nodeList)));
                    }
                    catch (NodelistNotFoundException e) {
                        Trace.out((String)("==== " + e.getMessage()));
                        throw new ComponentInitException(e.getMessage());
                    }
                }
                try {
                    this.m_nodeList = VerificationUtil.getNodelist();
                    Trace.out((String)("==== Nodelist for cluster integrity set to: " + VerificationUtil.strArr2List(this.m_nodeList)));
                }
                catch (NodelistNotFoundException e) {
                    throw new ComponentInitException(e.getMessage());
                }
                this.initNodeManager();
                break;
            }
            case 10: {
                this.m_IPAddrList = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_IPLIST);
                this.m_interfaceList = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_INTERFACELIST);
                if (!this.m_paramMgr.hasArgument(Argument.ARG_NETWORKLIST)) break;
                this.m_netArg = this.m_paramMgr.getArgument(Argument.ARG_NETWORKLIST);
                break;
            }
            case 12: {
                this.m_referenceNode = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_REFNODE);
                Trace.out((String)("==== ParamManager reports reference node as " + this.m_referenceNode));
                this.m_osdba = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSDBA);
                this.m_release = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_RELEASE);
                if ("10gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.1";
                } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.2";
                } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.1";
                } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.2";
                }
                this.m_oraInv = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ORAINV);
                this.m_paramPreReq = new ParamPreReqCRSInst();
                ((ParamPreReqCRSInst)this.m_paramPreReq).setRelease(this.m_release);
                if (this.m_osdba == null) {
                    this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                }
                if (this.m_oraInv == null) {
                    this.m_oraInv = VerificationUtil.getDefaultOraInvGroup();
                }
                if (this.m_osdba != null) {
                    ((ParamPreReqCRSInst)this.m_paramPreReq).setOSDBAgroup(this.m_osdba);
                }
                if (this.m_oraInv == null) break;
                ((ParamPreReqCRSInst)this.m_paramPreReq).setORAINVgroup(this.m_oraInv);
            }
        }
    }

    private boolean isRefNodeOk() {
        return this.m_isRefNodeOk;
    }

    @Override
    protected boolean checkSetup() {
        boolean succ = false;
        Object[] refNodeList = new String[]{this.m_referenceNode};
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        ResultSet tmpResultSet = new ResultSet();
        if (null != this.m_referenceNode) {
            if (!VerificationUtil.isNodeReachable(this.m_referenceNode)) {
                ReportUtil.printError(s_msgBundle.getMessage("4605", false, refNodeList));
                this.getResultSet().addResult(this.getNodeList(), 2);
                this.m_isRefNodeOk = false;
                return false;
            }
            if (!VerificationUtil.isUserEquivalenceOnNode(this.m_referenceNode, false)) {
                ReportUtil.printError(s_msgBundle.getMessage("4606", false, refNodeList));
                this.getResultSet().addResult(this.getNodeList(), 2);
                this.m_isRefNodeOk = false;
                return false;
            }
            boolean destLocSucc = VerificationUtil.checkDestLoc((String[])refNodeList, tmpResultSet, succNodes, failNodes, true);
            if (!destLocSucc) {
                Trace.out((String)"ReferenceNode didn't pass setup checks: checkDestLoc");
                this.getResultSet().addResult(this.getNodeList(), 2);
                this.m_isRefNodeOk = false;
                return false;
            }
        }
        succ = this.m_isRefNodeOk && super.checkSetup();
        return succ;
    }

    @Override
    public boolean verify() {
        boolean retval = this.checkSetup();
        if (!this.isRefNodeOk()) {
            return false;
        }
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 7: {
                if (!this.validateEnvironment()) {
                    return false;
                }
                TaskClusterIntegrity taskCluIntg = new TaskClusterIntegrity(validNodeArr);
                Trace.out((String)"\n>>>> ClusterComponent:: Upload taskCluIntg >>>>>\n");
                this.m_resultSet.uploadResultSet(taskCluIntg.getResultSet());
                return retval &= taskCluIntg.perform();
            }
            case 10: {
                TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(validNodeArr);
                if (this.m_netArg != null) {
                    try {
                        ClusterNetworkInfo netInfo = ClusterNetworkInfo.getNetworkInfoFromPMArg(this.m_netArg, validNodeArr[0]);
                        taskNodeCon.setInterfaceList(netInfo.getIfNames());
                        taskNodeCon.setSubnetList(netInfo.getSubnets());
                        taskNodeCon.setSubnetTypeList(netInfo.getNetTypes(true));
                    }
                    catch (CVUException cvuEx) {
                        String errMsg = cvuEx.getMessage();
                        ReportUtil.printError(errMsg);
                        Trace.out((String)("CVUException occured. mesg= " + errMsg));
                        this.m_resultSet.addResult(validNodeArr, 2);
                        this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                        return false;
                    }
                } else if (this.m_IPAddrList != null) {
                    taskNodeCon.setIPAddrList(this.m_IPAddrList);
                } else {
                    taskNodeCon.setInterfaceList(this.m_interfaceList);
                }
                taskNodeCon.setTaskType(0);
                Trace.out((String)"\n>>>> ClusterComponent:: Upload taskNodeCon >>>>>\n");
                this.m_resultSet.uploadResultSet(taskNodeCon.getResultSet());
                return retval &= taskNodeCon.perform();
            }
            case 12: {
                TaskPeerCompatibility taskPeerCompat = new TaskPeerCompatibility();
                taskPeerCompat.setNodeList(validNodeArr);
                taskPeerCompat.setReferenceNode(this.m_referenceNode);
                taskPeerCompat.setParamPreReq(this.m_paramPreReq);
                Trace.out((String)"\n>>>> ClusterComponent:: Upload taskPeerCompat >>>>>\n");
                this.m_resultSet.uploadResultSet(taskPeerCompat.getResultSet());
                this.m_resultSet.traceResultSet("Status of component rset before reporting ===> ");
                return retval &= taskPeerCompat.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "CLUSTER";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9952", false);
    }
}

